package coreservlets.tags;

/**
 *  PrimeTag zwraca do strony JSP losow liczb pierwsz.
 *  Dugo generowanej liczby pierwszej jest wyznaczana
 *  przez atrybut o nazwie length przekazywany przez stron JSP.
 *  Jeeli atrybut nie zostanie przekazany, przyjmowana jest
 *  domylna warto 50.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class PrimeTag extends SimplePrimeTag {
  public void setLength(String length) {
    try {
      this.length = Integer.parseInt(length);
    } catch(NumberFormatException nfe) {
      // Nic nie trzeba robi - length ma ju warto 50
    }
  }
}
